<?php
// app/Models/Tangki.php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Tangki extends Model
{
    protected $table = 'tangki';
    
    protected $fillable = [
        'desa_id', 'dusun_id', 'petugas_id', 'tanggal_pengiriman',
        'waktu_pengiriman', 'volume_air', 'prioritas', 'status', 'catatan'
    ];

    protected $casts = [
        'tanggal_pengiriman' => 'date',
    ];

    public function desa()
    {
        return $this->belongsTo(Desa::class);
    }

    public function dusun()
    {
        return $this->belongsTo(Dusun::class);
    }

    public function petugas()
    {
        return $this->belongsTo(User::class, 'petugas_id');
    }
}
